# S-Plus code: Example 12.4
# File: FCAR.r
# Coded by: ZONGWU CAI
# 
# THIS FILE IS FOR COMPUTING LOCAL LINEAR ESTIMATES OF COEFFICIENT FUNCTIONS in
# MODEL (23) BY USING Epanechnikov KERNEL. THE BANDWIDTH SELECTOR IS BASED ON (12) 
# in THE PAPER BY CAI, FAN AND YAO (2000). 
#
# IN THIS PROGRAM, TWO FUNCTIONS ARE DEFINED:: 
# localfit(...)  FOR COMPUTING LOCAL LINEAR ESTIMATION 
# bandwidth(...) FOR COMPUTING THE AMS-VALUES DEFINED IN (12) FOR CERTAIN 
#                RANGE OF BANDWIDTHS.
#
# Reference:
# Cai, Z, Fan, J., and Yao, Q. (2000).
#   Functional-coefficient regression models for nonlinear time series.
#   Journal of the American Statistical Association, 95 (451), 941-956.
#   DOI: 10.1080/01621459.2000.10474284. 
#
# TO RUN THIS PROGRAM, WHAT YOU NEED TO DO IS TO INPUT FOLLOWINGS:
# A.   You need to set following parameters according to your case. 
##############################################################################
pc <- 0    #(1) Set pc=1 for PC; set pc=0 for UNIX     
#               if(pc==1){datafile<-"c:\\res\\far\\scode\\sunspot.dat"}else
#               {datafile<-"sunspot.dat"}
           #(2) Set data file name: For instance: datafile="sunspot.dat", a data file name.
ps <- 1    #(3) Set ps=1 if you want to make and save graphs in TEMP
p  <- 1    #(4) set p, number of lagged variables in the model
d  <- 1    #(5) Set d, the varying variable, say, lagged-two variable
Q  <- -1   #(6) Set Q, choice of Q in (12); set Q = -1 by default (Q = 4)
h0 <- seq(0.01,10,by=0.05)  
           #(7) Set h0, a sequence of the possible values for bandwidths; 
           #    set h0 = -1 as default 
trans <- 1 #(8) Set trans = 1, if do squared-root transformation on response.
           # Note: you need to modify the program if transformation is different
nc <- 2    #(9) Set nc, the number of coefficient functions in model (23) 
     
# B. Type ("far4-c.s")    
############################################################################## 
 
   
#########################################################################
# YOU MIGHT NOT NEED TO MODIFY THE FOLLOWING CODE IF YOU DO NOT 
#########################################################################
  
#########################################################################
# READ DATA FROM DATA FILE. FOR EXAMPLE, sunspot data set
#########################################################################
    
data  <- logSST1825    #   matrix(scan(datafile), byrow=T, ncol=1)
data2 <- logWS1825
n     <- 1825 
# length(data)
if(trans==1){data<-1*((data))}       # do transformation
if(trans==1){data2<-1*((data2))}     # do transformation

y <- data2[(p+1):n]     # part2 = data2, part1 = data
x <- rep(0, nc*(n-p))
dim(x) <- c(n-p,nc)
x[,1]  <- data[(p-1+1):(n-1)]        # lagged variable
x[,2]  <- data2[(p-1+1):(n-1)]       # data[(p-2+1):(n-2)] lagged variable
#x[,3] <- data[(p-4+1):(n-4)]        # lagged variable
#x[,4] <- data[(p-5+1):(n-5)]        # lagged variable
#x[,5] <- data[(p-p+1):(n-p)]        # lagged variable                                
u <- data2[(1-d+1):(n-d)]            # varying variable  
z <- u                               # grid points for making graphs
   
########################################################################## 
# DEFINE FUNCTIONS
########################################################################## 
  
##########################################################################
kernel <- function(x){0.75*(1-x^2)*(abs(x)<=1)}  # DEFINE KERNEL FUNCTION
##########################################################################
  
  
###########################################################
# DEFINE THE FUNCTION TO COMPUTE the LOCAL LINEAR ESTIMATE
###########################################################
   
localfit <- function(y,x,h,u,z){
# y -- response variable; 
# x -- design matrix; 
# u -- varying variable;
# h -- bandwidth; 
# z -- grid point.
  
ngrid   <- length(z)            # number of grid points
n       <- length(y)            # number of data points
p       <- dim(x)[2]            # number of covariates
ff      <- rep(0,ngrid*p)
dim(ff) <- c(ngrid,p) 
p2      <- 2*p
for (k in 1:ngrid){
  dx     <- (u-z[k])*x
  dx     <- cbind(x,dx)      
  w0     <- kernel((u-z[k])/h)/h
  s0     <- t(dx)%*%(w0*dx)
  s1     <- solve(s0+0.001*diag(p2))
  beta   <- s1%*%(t(dx)%*%(w0*y))
  ff[k,] <- beta[1:p]
}
return(ff)
}
  
  
#################################################################
# DEFINE BANDWIDTH SELECTOR BASED ON equation (12) in JASA paper
#################################################################
   
bandwidth <- function(y,x,h0,u,Q){
# y - response; 
# x - design matrix; 
# u - varying variable; 
# h0 - possible bandwidths; 
# Q - value of folds
  
n <- length(y)               # sample size
if(Q<=0){Q<-4}
  if(sum(h0)<=0){
    y.range <- max(y)-min(y)
    aa      <- n^{-0.2}
    h0      <- 0.4*n^{-0.2}  # seq(0.4*y.range*aa,0.8*y.range*aa,by=0.1)  
                             # As default, set h0=c*n^{-0.2} with c from 0.4 to 0.8
  }
m        <- floor(0.1*n)     # define m
nh       <- length(h0)       # number of possible bandwidths
ams      <- rep(0,Q*nh)
dim(ams) <- c(nh,Q)
for(qq in 1:Q){
  n1 <- n-qq*m
  y0 <- y[1:n1]
  x0 <- x[1:n1,]
  u0 <- u[1:n1]
  z0 <- u[(n1+1):(n1+m)] 
  for(j in 1:nh){
    h         <- h0[j]*(n/n1)^0.2
    ff        <- localfit(y0,x0,h,u0,z0)             
    yhat      <- apply(x[(n1+1):(n1+m),]*ff,1,sum)
    ams[j,qq] <- mean((y[(n1+1):(n1+m)]-yhat)^2)
  }
}
ams <- apply(ams,1,sum)
return(cbind(h0,ams))
}
 
###########################################################################  
# DO COMPUTATION
##########################################################################
   
n <- length(y)
print("PLEASE WAIT, I AM SEARCHING FOR OPTIMAL BANDWIDTH")
ams   <- bandwidth(y,x,h0,u,Q)  # compute AMS for certain values of bandwidths
h0    <- ams[,1]
ind   <- order(ams[,2])[1]      # locate the index of optimal bandwidth
h.opt <- h0[ind]                # find the optimal bandwidth minimizing AMS
##h.opt <- 0.8*n^{-0.2}         # *(max(y)-min(y))  fixed bandwidth
  
print("I AM DONE THE OPTIMAL BANDWIDTH SEARCH")
print(c("THE OPTIMAL BANDWIDTH IS", h.opt))
  
ff   <- localfit(y,x,h.opt,u,z) # compute the final estimation 
ind  <- order(z)                
z    <- z[ind]                  # re-order data
ff   <- ff[ind,]
data <- cbind(z,ff)  
print("I AM DONE COMPUTATION")
  
if(pc==1){write(t(data),"c:\\temp\\myfile.out",ncol=nc+1)}else
  {write(t(data),"myfile.out",ncol=nc+1)}
# output data into file called *.out in TEMP

##########################################################################
# OUTPUT PS FILES FOR GRAPHS
##########################################################################
      
if(ps==1){      #  save the figure into a PS file called *.ps
  
print("PLEASE WAIT, I AM MAKING GRAPHS")

if(pc==1){
  filename<-c("c:\\temp\\myfile-f1.ps","c:\\temp\\myfile-f2.ps",
              "c:\\temp\\myfile-f3.ps","c:\\temp\\myfile-f6.ps",
              "c:\\temp\\myfile-f8.ps")}else
  {filename<-c("myfile-f1.ps","myfile-f2.ps","myfile-f3.ps","myfile-f6.ps",
               "myfile-f8.ps")
}

titlelab<-c("Estimated Coefficient Function a_1(u)", 
            "Estimated Coefficient Function a_2(u)",
            "Estimated Coefficient Function a_4(u)",
            "Estimated Coefficient Function a_5(u)",
            "Estimated Coefficient Function a_10(u)")   
         
if(pc==1){
  postscript(file="c:\\temp\\myfile-ts.ps", horizontal=F,width=8, height=8)
  }else{postscript(file="myfile-ts.ps", horizontal=F,width=8, height=8)
  }
  
  tsplot(y, type="b", cex=0.8)
  title(main="Time Series Plot for My Data", cex=0.8)
  dev.off()
  
  if(pc==1){
  postscript(file="c:\\temp\\myfile-h.ps", horizontal=F,width=8, height=8)
  }else{postscript(file="myfile-h.ps", horizontal=F,width=8, height=8)
  }
  
  matplot(h0, ams[,2], type="l",lty=c(1), cex=0.8)
  title(main="AMS versus bandwidth", cex=0.8)
  dev.off()
  
  for(j in 1:nc){
  postscript(file=filename[j], horizontal=F,width=8, height=8)
  matplot(z, ff[,j], type="l",lty=c(1), cex=0.8)
  title(main=titlelab[j], cex=0.8)
  dev.off()
  }
  
  }   # end of ps==1
  
print("I AM DONE")
  
#########################################################################
   
   
